//===============================================================================================
// Sets up and provides methods to support the dialog manager page that manages
// is responsible for managing the sequence of ipps dialog pages.
//
// Copyright <c> 2003 Intuit, Inc.  All rights reserved
//===============================================================================================

gDlg = null;			// dialog iframe element
gBannerWin = null;	// banner iframe window
gDlgWin = null;		// dialog iframe window
gCurPage = null;	// Current sequence map item

gMinDlgHeight = 495; // min dlg iframe height before scrolling is turned on


//-----------------------------------------------------------------------------------------------
function main()
	// Initialize the page when loaded
{
	setNormalBkgnd();

	gBannerWin = frames[0];
	
	gDlg = document.getElementById("dlg");
	gDlgWin = frames[1];
	
	onResize();
	onNext();
	gDlg.style.visibility = "visible";
}

//-----------------------------------------------------------------------------------------------
function isIE5()
	// Returns true if the brower is a variation of IE 5.x.
	// Returns false if the browser is a variation of IE 6.x
{
	return (navigator.appVersion.toLowerCase().indexOf("msie 5")!=-1);
}

//-----------------------------------------------------------------------------------------------
function setNormalBkgnd()
{
	var e=document.getElementById("watermark");
	if(e) e.style.visibility = "visible";

	if(isIE5()) document.body.className = "ie5";
	else document.documentElement.className = "";
}

//-----------------------------------------------------------------------------------------------
function setErrorBkgnd()
{
	// Hide the watermark	
	var e=document.getElementById("watermark");
	if(e) e.style.visibility = "hidden";
	
	if(isIE5()) document.body.className = "ie5Err";
	else document.documentElement.className = "err";
}

//-----------------------------------------------------------------------------------------------
function showCancelBtn(){ if(gBannerWin) gBannerWin.hideCancelBtn(true); }
function hideCancelBtn(){ if(gBannerWin) gBannerWin.hideCancelBtn(); }


//-----------------------------------------------------------------------------------------------
function onNext(id)
	// Handle dialog page transition
{
	if(!gDlgWin) return;
	
	var bOrigStyle = gDlgWin.document.body.style.visibility;
	gDlgWin.document.body.style.visibility = "hidden";
		// Hide the body of the page to avoid reclicks
	
	saveDlgData(gDlgWin);
		// Update the data source with the values on the dialog
	
	if( "back"!=id && gDlgWin.isDlgValid && !gDlgWin.isDlgValid() )
	{
		window.scrollTo(0,0);
		gDlgWin.document.body.style.visibility = bOrigStyle;
		return;
		// validate the data on the page if the validate function is present
	}
				
	runToNext(id);
}

//-----------------------------------------------------------------------------------------------
function runToNext(id)
	// Run to the next item in the sequence map
{
	hideCancelBtn();	

	var nextPage = gSequenceMap.runToNext( gCurPage, id );
	if( kUnknownID!=nextPage )
	{
		window.scrollTo(0,0);
			
		setNormalBkgnd();
			// Restore the background color
			
		gCurPage = nextPage;
		if(gDlgWin) gDlgWin.location.href = nextPage;
			// Load in the next dialog page
	}	
	else
	{	
		if(gDlgWin) gDlgWin.document.body.style.visibility = "visible";
		// on same page...show again
	}
}

//-----------------------------------------------------------------------------------------------
function runAct(action)
	// Callback from zSequenceMap::runToNext to run the action identified by the specified id
{
	var s = "gDlgWin." + action + "()";
	return result = eval( s ); 	
}


//-----------------------------------------------------------------------------------------------
function onDlgLoad()
	// Handler the load of the dialog page by exchanging data
{
	// get the page name and set it as the current page, gCurPage,
	// in case the browser back accelerator key was used 
	if( gDlgWin && gDlgWin.location )
	{
		var fn=gDlgWin.location.pathname;

		var pos=fn.lastIndexOf('\\');
		if( pos<0 ) pos=fn.lastIndexOf('/');

		if( pos<0 )gCurPage = fn;
		else gCurPage = fn.substr(pos+1);
		
		// Append the query string, to enable uniqueness within
		// the sequence map
		if( gDlgWin.location.search.length > 0 ) gCurPage += gDlgWin.location.search;
	}

	initDlgData(gDlgWin);
}

//-----------------------------------------------------------------------------------------------
function onResize()
	// Handle the resizing of the window
{
	var winH=window.document.documentElement.clientHeight;
	if(winH<1) winH=window.document.body.offsetHeight;
	if(winH<1) winH=400;

	// Position the watermark at the bottom of the page
	var wm = document.getElementById("watermark");
	if( wm )
	{
		var wmY = winH - wm.offsetHeight;
		wm.style.top = wmY + "px";
	}
	
	// resize the dialog area to fill up the new window height
	
	var bnr = document.getElementById("banner");
	var y = (bnr) ? bnr.offsetHeight : 0;
	var h = winH - y;
	if( h < gMinDlgHeight && screen.availHeight > gMinDlgHeight ) h = gMinDlgHeight;
	
	gDlg.style.top = y+"px";
	gDlg.style.height = h+"px";
}

//-----------------------------------------------------------------------------------------------
function onPrint()
	// Print the contents of this window
{
	window.print();
}

//-----------------------------------------------------------------------------------------------
// Setup
//-----------------------------------------------------------------------------------------------
window.onresize = onResize;
	// Setup the window resize handler
	